//
//  NovusAPI.h
//  Daemons
//
//  Created by Karl Løland on 9/27/11.
//  Copyright 2011 Altinett AS. All rights reserved.
//

#import <Foundation/Foundation.h>

@protocol NovusAPI <NSObject>

@required
- (BOOL) installPkg: (NSString*) pkg withInstallPath: (NSString*) installPath;

- (BOOL) installApplication: (NSString*) app toPath: (NSString*) path;
- (BOOL) installCompressedApplication: (NSString*) app toPath: (NSString*) path;
- (BOOL) updateApplicationWithIdentifier: (NSString*) identifier withNewApplication: (NSString*) newApp;

- (BOOL) installDaemonWithIdentifier: (NSString*) identifier andBinary: (NSString*) binaryPath;

- (BOOL) installNetworkSettingsForModem:(NSString*)modemName withName:(NSString*) name;

- (BOOL) removeFile:(NSString*) path;
- (BOOL) removeFolder:(NSString*) path;
- (BOOL) removeAndUnregisterHelperWithIdentifier:(NSString*) identifier;
- (BOOL) removeAndUnregisterKextWithIdentifier:(NSString*) identifier;
- (BOOL) removeMobilePartner;
- (void) restartDock;
- (BOOL) killApplication:(NSString*) identifier;


- (BOOL) changeIconForBundle:(NSString*)bundle withIcon:(NSString*) iconName;
- (BOOL) killAppWithIdentifier: (NSString*) identifier;
- (BOOL) changeFileNameFrom:(NSString*) oldPath to:(NSString*) newPath;
@optional
-(void) syslog: (NSString*) string;
-(NSString*) echo: (NSString*) string;
@end
